# Anlegen der Server webserver01 und webserver02
ansible-playbook -i inventory.yml 01pb_hwebserver.yml -e@vault.yml

## ggf. alten Fingerprint löschen
ssh-keygen -f "/home/<USERNAME>/.ssh/known_hosts" -R "<IP-Adresse>"

## Erste Anmeldung und Fingerprint übernehmen

~~~
ssh root@<IP-Adresse>
~~~

 - IP-Adresse in inventory.yml übernehmen

# nginx installieren per apt

ansible-playbook 02pb_hnginx.yml -e@vault.yml --ask-pass

# docker installieren aus fremd-Repository

ansible-playbook 03pb_hnginx.yml -e@vault.yml --ask-pass

# nextcloud/mariadb als docker container installieren

ansible-playbook 04pb_hnginx.yml -e@vault.yml --ask-pass

--------

# anlegen der vault.yml (Passwort-Tresor)

ansible-vault create vault.yml 
ansible-vault edit vault.yml
ansible-vault view vault.yml

HIER: test123 bitte damit nicht live Arbeiten!

ansible-vault encrypt vault.yml
Es wird standardmäßig vi als Editor aufgerufen.
i -> in Editiermodus wechseln (**i**nsert)
ESC -> Editiermodus beenden
:wq -> speicher (**w**rite) und schließen (**q**uit)

Beim Schließen wird man aufgefordert ein Passwort für die vault.yml zuvergeben. Dies sollte man sich gut merken, da die Datei mit AES128 verschlüsselt wird.
Das Passwort wird durch "--ask-pass" bei jedem Aufruf abgefragt.

## Inhalt vault.yml

hcloud_token: <Hetzner-Cloud-Token> # Muss bei Hetzner runterladen werden.
web01_password: <ganzgeheimespasswort> # hier kann ein beliebiges Passwort hinterlegt werden. s. inventory.yml


# Mehr Komfort durch ansible.cfg

Die ansible.cfg nimmt viel Tipparbeit ab, wenn man dort gewisse Parameter (wie inventory=inventory.yml) bereits hinterlegt. Man spart dann den Parameter "-i inventory.yml" bei jedem Aufruf.

Mit "vault_password_file = ~/.ssh/<IGENDEINDATEINAME>" kann man das Passwort für die vault.yml hinterlegen. Aber VORSICHT! Die Datei darf niemand in die Hände bekommen, ansonsten könnt Ihr die Passwörter gleich ans Schwarze Brett hängen.

Mit "private_key_file=~/.ssh/id_rsa-hetzner" könnt Ihr den private Key für die Hetzner-Cloud hinterlegen.

Mit dem Abschnitt [inventory] wird die Hetzner-API eingebunden, diese muss explizit (hier nicht beschrieben) als python-Module installiert werden.
~~~
[inventory]
enable_plugins = hcloud, yaml
~~~

# sonstige ansible Befehle
ansible-inventory --list

# Server wieder löschen und austragen der ssh-Fingerprints aus known_hosts
ansible-playbook hwebserver_delete.yml -e@vault.yml



